# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    if always_cooperate:
        return "D"
    if always_defect:
        return "D"
    
    # Initial rounds (1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "C" if opp_history[0] == "C" else "D"
    elif current_round == 3:
        return opp_history[1] if len(opp_history) > 1 else "C"
    
    # Middle rounds (4-7)
    if 4 <= current_round <= 7:
        coop_count = opp_history[:3].count("C")
        if coop_count >= 2:
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            return "C"
        else:
            return opp_history[-1] if opp_history else "C"
    
    # Final rounds (8-10)
    if current_round >= 8:
        if current_round == 10 and "D" in opp_history[-3:]:
            return "D"
        coop_count = opp_history[:7].count("C") if len(opp_history) >= 7 else opp_history.count("C")
        if coop_count >= 5:
            return "C"
        else:
            return "D"
    
    # Default fallback
    return "C"